<?php
class Registration
{
  private $dbo = null;
  
  private $fields = array();
  
  function __construct($dbo)
  {
    $this->dbo = $dbo;
    $this->initFields();
  }
  
  function initFields()
  {
    $this->fields['email'] = new FormInput('email', 'Adres e-mail');
    $this->fields['haso'] = new FormInput('haso', 'Haso', '', 'password');
    $this->fields['haso2'] = new FormInput('haso2', 'Powtrz haso', '', 'password');
    $this->fields['imi'] = new FormInput('imi', 'Imi');
    $this->fields['nazwisko'] = new FormInput('nazwisko', 'Nazwisko');
    $this->fields['ulica'] = new FormInput('ulica', 'Ulica');
    $this->fields['nr_domu'] = new FormInput('nr_domu', 'Numer domu');
    $this->fields['nr_mieszkania'] =  
      new FormInput('nr_mieszkania', 'Numer mieszkania', '', 'text', false);
    $this->fields['miejscowo'] = new FormInput('miejscowo', 'Miejscowo');
    $this->fields['kod'] = new FormInput('kod', 'Kod pocztowy');
    $this->fields['kraj'] = new FormInput('kraj', 'Kraj');
  }
  
  function showRegistrationForm()
  {
    foreach($this->fields as $name => $field){
      $field->value = isset($_SESSION['formData'][$name]) ? $_SESSION['formData'][$name] : '';
    }
    $formData = $this->fields;
    if(isset($_SESSION['formData'])){
      unset($_SESSION['formData']);
    }
    include 'templates/registrationForm.php'; 
  }
  
  function registerUser()
  {
    foreach($this->fields as $name => $val){
      if(!isset($_POST[$name])){
        return FORM_DATA_MISSING;
      }
    }
    
    //Tutaj lub po przefiltrowaniu dodatkowa weryfikacja danych,
    //w tym sprawdzenie dugoci cigw, znakw niedozwolonych itp
    
    //Odczyt i przefiltrowanie danych z formularza
    $fieldsFromForm = array();
    $emptyFieldDetected = false;
    foreach($this->fields as $name => $val){
      if($val->type != 'password'){
        $fieldsFromForm[$name] = filter_input(INPUT_POST, $name, 
                                 FILTER_SANITIZE_SPECIAL_CHARS);
      } else {
        $fieldsFromForm[$name] = $_POST[$name];
      }
      
      $fieldsFromForm[$name] = 
        $this->dbo->real_escape_string($fieldsFromForm[$name]);
        
      if($fieldsFromForm[$name] == '' && $val->required){
        $emptyFieldDetected = true;
      }
    }
    
    //Sprawdzenie czy wykryto puste pola
    if($emptyFieldDetected){
      unset($fieldsFromForm['haso']);
      unset($fieldsFromForm['haso2']);
      $_SESSION['formData'] = $fieldsFromForm;
      return FORM_DATA_MISSING;
    }
    
    //Sprawdzenie czy podany e-mail jest ju w bazie
    $query = "SELECT COUNT(*) FROM Klienci WHERE Email='"
           . $fieldsFromForm['email'] . "'";
    if($this->dbo->getQuerySingleResult($query) > 0){
      unset($fieldsFromForm['haso']);
      unset($fieldsFromForm['haso2']);
      $_SESSION['formData'] = $fieldsFromForm;
      return USER_NAME_ALREADY_EXISTS;
    }
    
    //Sprawdzenie zgodnoci hasa z obu pl
    if($fieldsFromForm['haso'] != $fieldsFromForm['haso2']){
      unset($fieldsFromForm['haso']);
      unset($fieldsFromForm['haso2']);
      $_SESSION['formData'] = $fieldsFromForm;
      return PASSWORDS_DO_NOT_MATCH;
    }
    unset($fieldsFromForm['haso2']);
    unset($this->fields['haso2']);
    
    //Zakodowanie hasa.
    $fieldsFromForm['haso'] = crypt($fieldsFromForm['haso']);
    
    //Przygotowanie cigw nazw pl i wartoci pl dla zapytania SQL
    $fieldsNames = '`'.implode('`,`', array_keys($this->fields)).'`';
    $fieldsVals = '\''.implode('\',\'', $fieldsFromForm).'\'';
    
    //Formowanie i wykonanie zapytania
    $query = "INSERT INTO Klienci ($fieldsNames) VALUES ($fieldsVals)";

    if($this->dbo->query($query)){
      return ACTION_OK;
    }
    else{
      unset($fieldsFromForm['haso']);
      $_SESSION['formData'] = $fieldsFromForm;
      return ACTION_FAILED;
    }
  }
}